@extends('admin.layouts.main')
@section('title')
    {{ __('page.APP_ADMOB_AND_WEATHER_KEY_SETUP') }}
@endsection
@section('pre-title')
    {{ __('page.APP_ADMOB_AND_WEATHER_KEY_SETUP') }}
@endsection
@section('page-title')
    <div class="row g-2 align-items-center">
        <div class="col">
            <!-- Page pre-title -->
            <div class="page-pretitle">
                <a href="{{ url('admin/dashboard') }}">{{ __('page.HOME') }}/</a>
                <a href="{{ url('admin/settings') }}">{{ __('page.SETTINGS') }}/</a>
                @yield('pre-title')
            </div>
            <h2 class="page-title">
                @yield('title')
            </h2>
        </div>
        <!-- Page title actions -->
        <div class="col-auto ms-auto d-print-none">
        </div>
    </div>
@endsection
@section('content')
    <section class="section m-2">
        <div>
            <form action="{{ route('settings.app-keys-settings') }}" method="post" id="createCompanySetupForm"
                enctype="multipart/form-data">
                @csrf
                <div class="row d-flex mb-3">
                    <div class="card admin_cards">
                        <div class="card-header">
                            <h3 class="card-title">{{ __('page.ADMOB_KEYS_SETUP') }}
                                <i class="bi bi-info-circle-fill text-muted m-1 cursor-pointer" data-bs-toggle="tooltip"
                                    data-bs-placement="right" title="{{ __('page.COMPANY_DETAILS_HINT') }}"></i>
                            </h3>

                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-12 form-group mandatory">
                                    <label for="admob_app_id" class="col-sm-6 col-md-6 form-label">
                                        {{ __('page.ADMOB_APP_ID') }}<span class="text-danger">*</span>
                                    </label>
                                    <input name="admob_app_id" type="text" class="form-control" id="admob_app_id"
                                        placeholder="{{ __('page.ADMOB_APP_ID') }}"
                                        value="{{ $settings['admob_app_id'] ?? '' }}" />
                                    <span class="parsley-required"><strong id="admob-app-id-error"></strong></span>
                                </div>

                                <div class="col-sm-12 form-group mandatory mt-3">
                                    <label for="banner_ad_key" class="col-sm-12 col-md-6 form-label mt-1">
                                        {{ __('page.BANNER_AD_KEY') }}<span class="text-danger">*</span>
                                    </label>
                                    <input id="banner_ad_key" name="banner_ad_key" type="text" class="form-control"
                                        placeholder="{{ __('page.BANNER_AD_KEY') }}"
                                        value="{{ $settings['banner_ad_key'] ?? '' }}" />
                                    <span class="parsley-required"><strong id="banner-ad-key-error"></strong></span>
                                </div>

                                <div class="col-sm-12 form-group mandatory mt-3">
                                    <label for="interstitial_ad_key" class="col-sm-12 col-md-6 form-label mt-1">
                                        {{ __('page.INTERSTITIAL_AD_KEY') }}<span class="text-danger">*</span>
                                    </label>
                                    <input id="interstitial_ad_key" name="interstitial_ad_key" type="text"
                                        class="form-control" placeholder="{{ __('page.INTERSTITIAL_AD_KEY') }}"
                                        value="{{ $settings['interstitial_ad_key'] ?? '' }}">
                                    <span class="parsley-required"><strong id="interstitial-ad-key-error"></strong></span>
                                </div>


                                <div class="col-sm-12 form-group mandatory mt-3">
                                    <label for="open_ad_key" class="col-sm-12 col-md-6 form-label mt-1">
                                        {{ __('page.OPEN_AD_KEY') }}<span class="text-danger">*</span>
                                    </label>
                                    <input id="open_ad_key" name="open_ad_key" type="text" class="form-control"
                                        placeholder="{{ __('page.OPEN_AD_KEY') }}"
                                        value="{{ $settings['open_ad_key'] ?? '' }}">
                                    <span class="parsley-required"><strong id="open-ad-key-error"></strong></span>
                                </div>

                            </div>
                            <div class="col-12 mt-3 d-flex justify-content-end">
                                <button class="btn btn-primary me-1 mb-1" type="submit"
                                    name="submit">{{ __('page.SAVE') }}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
    
    <section class="section m-2">
        <div>
            <form action="{{ route('settings.store') }}" method="post" method="post" enctype="multipart/form-data">
                @csrf
                <div class="row d-flex mb-3">

                    <div class="card mt-3 admin_cards m-2">
                        <div class="card-header">
                            <h3 class="card-title">{{ __('page.LOGO_IMAGES') }}</h3>
                        </div>
                        <div class="card mt-3 admin_cards m-2">

                            <div class="card-body">
                                <div class="row">

                                    <div class="col-sm-6 form-group mandatory mt-3">
                                        <label for="weather_api_key" class="form-label ">{{ __('page.WEATHER_API_KEY') }}
                                            <i class="bi bi-info-circle-fill text-muted m-1 cursor-pointer"
                                                data-bs-toggle="tooltip" data-bs-placement="right"
                                                title="{{ __('Provide the API key for accessing weather data on your website.') }}"></i><span
                                                class="m-2"><a href="https://home.openweathermap.org/">Visit
                                                    openweathermap.org</a></span>
                                        </label>
                                        <input class="form-control" type="text" name="weather_api_key"
                                            placeholder={{ __('page.ENTER_WEATHER_API_KEY') }}
                                            value="{{ $settings['weather_api_key'] ?? '' }}" id="weather_api_key">
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="card mt-3 admin_cards m-2">
                            <div class="card-body">
                                <div class="col-12 mt-3 d-flex justify-content-end">
                                    <button class="btn btn-primary me-1 mb-1" type="submit"
                                        name="submit">{{ __('page.SAVE') }}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
@endsection